// importation des bibliothèques

// variables utilisées par tous les programmes
int BAUD = 9600 ;
String info = "Programme modèle acquisition" ;
long delai = 1000 ; // en ms
unsigned long start = 0 ; 
unsigned long last = 0 ; 
int action = 0 ; // 0 : on ne fait rien - 1 : on appel job

// variables spécifiques au programme 
int POTAR = A0 ; 

void setup()
{
  Serial.begin(BAUD) ;
  Serial.println(info) ;
}

void loop()
{
  if (Serial.available())
  {
    String message = Serial.readString() ;
    parse(message) ;
  }
  if (action == 1)
  {
    if (millis() - last > delai)
    {
      last = millis() ; 
      job() ; 
    }
  }
}

/********* INTERPRETATION DES MESSAGES RECUS *************/

void parse(String msg)
{
  msg.replace("\r", "") ;
  msg.replace("\n", "") ;
  char ordre = msg[0];
  msg.replace(String(ordre), "") ;
  int valeur = 0 ;
  if (msg.length() > 0)
    valeur = msg.toInt() ;
  switch (ordre)
  {
    case 'I' :
      Serial.println(info) ;
      break ;
    case 'G' : // exécution d'une tâche régulièrement
      go() ;
      break ;
    case 'O' : // exécution d'une tâche unique
      job() ;
      break ;
    case 'S' : // on stoppe
      stop() ;
      break ;
    case 'D' : // réglage du délai
      delai = valeur ;
      break ;
    default :
      parse(ordre, valeur) ;
      break ;
  }
}

void parse(char ordre, long valeur) // traitements spécifiques au système
{
  switch (ordre)
  {
    case 'R' :
      break ;
  }
}

/********* GO - STOP *************/

void go()
{
  start = millis() ;
  action = 1 ; 
}

void stop()
{
  action = 0 ;
}

/********* JOB *************/

void job()
{
  String msg = "TIME:" + String(millis()-start) ; 
  msg = msg + ":A0:" + String(analogRead(POTAR)) ; 
  Serial.println(msg) ; 
}
