// ***** MiniShield Accelerometre ***** //

#include <SPI.h>

// capteur 9DOF : sur port I2C
#include <Wire.h>
#include <MPU9250_WE.h>

// bibliothèque pour affichage sur écran LCD
#include <Adafruit_SSD1306.h>

// variables spécifiques au système étudié
#define MPU9250_ADDR 0x68  // 0x69 si ADO connecté à VCC
MPU9250_WE mpu = MPU9250_WE(MPU9250_ADDR);

Adafruit_SSD1306 lcd(4);

// variables utilisées pour tous les programmes :
#define BAUD 115200  // vitesse d'échange pour le port série
#define Info "Programme général du  MiniShield 9DOF"
unsigned long start = 0 ;
unsigned long last = 0 ;
long delai = 1000 ; // Delai en ms entre 2 appels de la fonction job
bool doJob = false ;

// **********************************************

void setup()
{
  Serial.begin(BAUD) ;
  
  Wire.begin();
  delay(500);
  Serial.println(Info) ;
  Serial.println("Tapez G pour GO") ;
  Serial.println("Tapez S pour STOP") ;
  Serial.println("Tapez O pour acquisition unique") ;
  Serial.println("Tapez Dxxx pour un délain de xxx ms entre acquisition") ;
  Serial.println("----") ;

lcd.begin(SSD1306_SWITCHCAPVCC, 0x3C);  
  lcd.setTextSize(1);
  lcd.setTextColor(WHITE);
  lcd.clearDisplay() ;
  lcd.setCursor(0,0);
  lcd.println("Calibration") ; 
  lcd.println("Ne pas bouger !") ; 
  lcd.display();
  
    Serial.println("Calibration de l'accéléromètre-gyroscope dans 2 secondes") ;
    Serial.println("Placer le capteur sur une surface plate et attendre !") ; 
    delay(2000);
    
  if(!mpu.init()){
    Serial.println("MPU9250 does not respond");
  }
  else{
    Serial.println("MPU9250 is connected");
  }
  if(!mpu.initMagnetometer()){
    Serial.println("Magnetometer does not respond");
  }
  else{
    Serial.println("Magnetometer is connected");
  }
  mpu.autoOffsets();
  mpu.enableGyrDLPF();
  mpu.setGyrDLPF(MPU9250_DLPF_6);
  mpu.setSampleRateDivider(5);
  mpu.setGyrRange(MPU9250_GYRO_RANGE_250);
  mpu.setAccRange(MPU9250_ACC_RANGE_2G);
  mpu.enableAccDLPF(true);
  mpu.setAccDLPF(MPU9250_DLPF_6);
  mpu.setMagOpMode(AK8963_CONT_MODE_100HZ);
  delay(200);
  Serial.println("GO") ;
  go() ; 
}

void loop()
{
  if (Serial.available())
  {
    String message = Serial.readString() ;
    parse(message) ;
  }
  if (doJob && millis() - last > delai)
  {
    job() ;
    last = millis() ;
  }
}

void parse(String msg)
{
  float somme ;
  msg.replace("\r", "") ;
  msg.replace("\n", "") ;
  msg.replace(":", "") ;
  char ordre = msg[0];
  msg.replace(String(ordre), "") ;
  int valeur = 0 ;
  if (msg.length() > 0)
    valeur = msg.toInt() ;
  switch (ordre)
  {
    case 'I' :
      Serial.println(msg);
      break ;
    case 'G' :
      go() ;
      break ;
    case 'O' :
      job() ;
      break ;
    case 'S' :
      stop() ;
      break ;
    case 'D' :
      delai = valeur ;
      break ;
    default :
      parse(ordre, valeur) ;
      break ;
  }
}

void go()
{
  doJob = true ;
  start = millis() ;
}

void stop()
{
  doJob = false ; // on éteind la LED
}

// traitement spécifique au système étudié

void parse(char ordre, long valeur)
{
  switch (ordre)
  {
    default :
      break ;
  }
}

void job()
{
  xyzFloat gValue = mpu.getGValues();
  xyzFloat gyr = mpu.getGyrValues();
  xyzFloat magValue = mpu.getMagValues();
  float temp = mpu.getTemperature();
  float resultantG = mpu.getResultantG(gValue);

  Serial.print("DATA:TIME(ms):" + String(millis() - start)) ;
  Serial.print(":Ax:" + String(gValue.x)) ;
  Serial.print(":Ay:" + String(gValue.y)) ; 
  Serial.print(":Az:" + String (gValue.z)) ; 
  Serial.print(":Atot:" + String (resultantG)) ;
  Serial.print(":Gyrx:" + String(gyr.x)) ;
  Serial.print(":Gyry:" + String(gyr.y)) ; 
  Serial.print(":Gyrz:" + String (gyr.z)) ; 
  Serial.print(":Magx:" + String(magValue.x)) ;
  Serial.print(":Magy:" + String(magValue.y)) ; 
  Serial.print(":Magz:" + String (magValue.z)) ;
  Serial.println(":T:" + String(temp)) ; 

  lcd.clearDisplay();
  lcd.setCursor(0,0);
  lcd.print("Ax : ") ;
  lcd.println(String(gValue.x)) ; 
  lcd.print("Ay : ") ;
  lcd.println(String(gValue.y)) ; 
  lcd.print("Az : ") ;
  lcd.println(String(gValue.z)) ; 
  lcd.print("Atot : ") ;
  lcd.println(String(resultantG)) ; 
  lcd.display() ; 
}
