// ***** MiniShield Accelerometre ***** //

#include <SPI.h>

// capteur 9DOF : sur port I2C
#include <Wire.h>
#include <MPU9250_WE.h>


// variables spécifiques au système étudié
MPU9250_WE mpu1 = MPU9250_WE(0x68);
MPU9250_WE mpu2 = MPU9250_WE(0x69);


// variables utilisées pour tous les programmes :
#define BAUD 115200  // vitesse d'échange pour le port série
#define Info "Programme MiniShield 9DOF double"
unsigned long start = 0 ;
unsigned long last = 0 ;
long delai = 1000 ; // Delai en ms entre 2 appels de la fonction job
bool doJob = false ;

// **********************************************

void setup()
{
  Serial.begin(BAUD) ;
  
  Wire.begin();
  delay(500);
  Serial.println(Info) ;
  Serial.println("Tapez G pour GO") ;
  Serial.println("Tapez S pour STOP") ;
  Serial.println("Tapez O pour acquisition unique") ;
  Serial.println("Tapez Dxxx pour un délain de xxx ms entre acquisition") ;
  Serial.println("----") ;
  
    Serial.println("Calibration de l'accéléromètre-gyroscope dans 2 secondes") ;
    Serial.println("Placer le capteur sur une surface plate et attendre !") ; 
    delay(2000);
    
  if(!mpu1.init()){
    Serial.println("MPU9250 (AD0 connecté à GND) does not respond");
  }
  else{
    Serial.println("MPU9250 (AD0 connecté à GND) is connected");
  }
  if(!mpu2.init()){
    Serial.println("MPU9250 (AD0 connecté à VCC) does not respond");
  }
  else{
    Serial.println("MPU9250 (AD0 connecté à VCC) is connected");
  }
  
  mpu1.autoOffsets();;
  mpu1.setSampleRateDivider(5);
  mpu1.setAccRange(MPU9250_ACC_RANGE_2G);
  mpu1.enableAccDLPF(true);
  mpu1.setAccDLPF(MPU9250_DLPF_6);
  
  mpu2.autoOffsets();;
  mpu2.setSampleRateDivider(5);
  mpu2.setAccRange(MPU9250_ACC_RANGE_2G);
  mpu2.enableAccDLPF(true);
  mpu2.setAccDLPF(MPU9250_DLPF_6);
  
  delay(200);
  Serial.println("GO") ;
  go() ; 
}

void loop()
{
  if (Serial.available())
  {
    String message = Serial.readString() ;
    parse(message) ;
  }
  if (doJob && millis() - last > delai)
  {
    job() ;
    last = millis() ;
  }
}

void parse(String msg)
{
  float somme ;
  msg.replace("\r", "") ;
  msg.replace("\n", "") ;
  msg.replace(":", "") ;
  char ordre = msg[0];
  msg.replace(String(ordre), "") ;
  int valeur = 0 ;
  if (msg.length() > 0)
    valeur = msg.toInt() ;
  switch (ordre)
  {
    case 'I' :
      Serial.println(msg);
      break ;
    case 'G' :
      go() ;
      break ;
    case 'O' :
      job() ;
      break ;
    case 'S' :
      stop() ;
      break ;
    case 'D' :
      delai = valeur ;
      break ;
    default :
      parse(ordre, valeur) ;
      break ;
  }
}

void go()
{
  doJob = true ;
  start = millis() ;
}

void stop()
{
  doJob = false ; // on éteind la LED
}

// traitement spécifique au système étudié

void parse(char ordre, long valeur)
{
  switch (ordre)
  {
    default :
      break ;
  }
}

void job()
{
  xyzFloat gValue1 = mpu1.getGValues();
  xyzFloat gValue2 = mpu2.getGValues();
  float resultantG1 = mpu1.getResultantG(gValue1);
  float resultantG2 = mpu2.getResultantG(gValue2);

  Serial.print("DATA:TIME(ms):" + String(millis() - start)) ;
  Serial.print(":Ax1:" + String(gValue1.x)) ;
  Serial.print(":Ay1:" + String(gValue1.y)) ; 
  Serial.print(":Az1:" + String (gValue1.z)) ; 
  Serial.print(":Atot1:" + String (resultantG1)) ;
  Serial.print(":Ax2:" + String(gValue2.x)) ;
  Serial.print(":Ay2:" + String(gValue2.y)) ; 
  Serial.print(":Az2:" + String (gValue2.z)) ; 
  Serial.println(":Atot2:" + String (resultantG2)) ;
  
}
