#include <Wire.h>
#include <Adafruit_BMP280.h>
#include <Adafruit_SSD1306.h>

// variables spécifiques au système étudié
Adafruit_SSD1306 lcd(4);
Adafruit_BMP280 bmp;

#define analogPin   A2
// fonction de transfert MPX5500  : Vout = Vs(Ha.P + Hb) avec P en kPa
#define Ha 0.0018   // à modifier si besoin
#define Hb 0.04     // à modifier si besoin
float offset = -26 ;   // à modifier si besoin => pour avoir 0 quand deltaP = 0 ! 

// variables utilisées pour tous les programmes :
unsigned long last = 0 ;
long delai = 1000 ; // Delai en ms entre 2 appels de la fonction job

void setup()
{
  Serial.begin(115200) ;
  if (!bmp.begin())
  {
    Serial.println("INFO:Problème avec capteur BMEP80") ;
  }
  Serial.println("MiniShield Pression") ; 
  lcd.begin(SSD1306_SWITCHCAPVCC, 0x3C);  
  lcd.setTextSize(1);
  lcd.setTextColor(WHITE);
  lcd.clearDisplay() ;
  lcd.setCursor(0,0);
  lcd.print("MiniShield P") ; 
  lcd.display()  ;
}

void loop()
{
  if (millis() - last > delai)
  {
    int sensorValue = analogRead(analogPin);
    float p = 10*(((sensorValue / 1023.0) - Hb) / Ha) - offset ; // en hPa
    
    String msg = "DATA:TIME(s):" + String(millis()/1000.0,0) ;
    msg = msg + ":T:" + String(bmp.readTemperature(),1) + ":P(Pa):" + String(bmp.readPressure(),0)  ;
    msg = msg + ":deltaP(hPa):" + String(p,0);
    Serial.println(msg) ; 

    
  lcd.clearDisplay();
  lcd.setCursor(0,0);
  lcd.print("T = ") ; 
  lcd.println(String(bmp.readTemperature(),1)) ;
  lcd.setCursor(0,12);
  lcd.print("P(Pa) = ") ;
  lcd.println(String(bmp.readPressure(),0)) ; 
  lcd.setCursor(0,24);
  lcd.print("dP(hPa) = ") ;
  lcd.println(String(p,0)) ; 
  lcd.display() ; 
  
    last = millis() ;
  }
}
