#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Thu Aug 31 19:43:42 2017

@author: Alain
"""

""" importation de bibliothèques """
import matplotlib.pyplot as plt


""" constantes (variables) globales nécessaires à l'ensemble du programme """

Ke = pow(10,-14)
BBT = [7.0,250,254,199,218,254,239]#pka rgb acide rgb basique
HEL = [3.7,255,149,149,254,208,146]
PHIPHI = [9.6,255,240,252,254,171,230]
Indicateur = ["Hélianthine", "Bleu de bromothymol", "Phénol-phtaléine"]
ChoixIndicateur=[HEL, BBT, PHIPHI]

""" routines utilitaires """

def f(h,C0,V0,Ct,Vt,Ka): # commentaire supprimé pour vous demander ce que fait la fonction f ?
    return (h - Ke/h)*(V0 + Vt) + Ct*Vt - C0*V0/(1 + h/Ka)
   
def zorglub(C0,V0,Ct,Vt,Ka): # commentaire supprimé pour vous demander ce que fait la fonction zorglub ?
    a=0
    b=14
    fa = f(pow(10,-a), C0, V0, Ct, Vt, Ka)
    while b - a > 0.01 :
        c = (a+b)/2
        fc = f(pow(10,-c), C0, V0, Ct, Vt, Ka)
        if (fa *fc < 0):
            b = c
        else:
            a = c
            fa = fc
    return (a+b)/2

""" 
calcul des 3 composantes de la couleur pour l'indicateur coloré pour un pH donné par un modèle simple à expliciter
"""
def couleur(Indicateur, pH): #RGB de l'indicateur coloré pour un mélange donné
    h = pow(10,-pH)
    Ka = pow(10,-Indicateur[0])
    pctA = 100/(1 + Ka/h)
    pctB = 100/(1 + h/Ka)
    r = (Indicateur[1]*pctA + Indicateur[4]*pctB)/100
    g = (Indicateur[2]*pctA + Indicateur[5]*pctB)/100
    b = (Indicateur[3]*pctA + Indicateur[6]*pctB)/100
    return (r/256,g/256,b/256)
     
"""
    programme principal
"""   
V = [] # tableau de valeur pour stocker les volumes
PH = [] # tableau de valeur pour stocker les pH correspondants
v = 0 # volume "courant"
Ca = 0.01 #concentration en acide titré
Va = 100 #volume titré
Cb = 0.1 #concentration en base
pas = 0.01 #pas d'incrémentation du volume
Vmax = 25 # volume maximal de réactif titrant

while v <= Vmax : 
    V.append(v)
    ppH = zorglub(0.01, 100, 0.1, v, pow(10,-4))
    PH.append(ppH)
    v = v + pas

# on affiche une première fois la courbe
plt.plot(V, PH)
plt.show()

# on demande le choix de l'indicateur
reponse = input("Choix de l'indicateur coloré : 0 pour hélianthine, 1 pour bleu de bromothymol ou 2 pour phénol phtaléine) ?")
choix = int(reponse)

#on affiche la courbe si le choix est valide
if choix > 2 :
    print("Il fallait taper un nombre entre 0 et 1 !")
else:
    for i in range(len(V)-1):
        plt.fill([V[i], V[i+1], V[i+1], V[i]], [0,0,12,12], color = couleur(ChoixIndicateur[choix], (PH[i]+PH[i+1])/2), alpha = 0.5)
    plt.plot(V, PH)
    plt.xlabel("Volume (mL)")
    plt.ylabel("pH")
    plt.title("Indicateur utilisé : " + Indicateur[choix])
    plt.show()
    

