#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Wed Oct  4 13:15:49 2017

@author: Alain
"""


""" LECTURE DU FICHIER TEXTE """
fichier = open("GenomeTomatoBushy.txt")
seq = fichier.read()
fichier.close()


""" Checksum """

def checksum(txt):
    s1 = 0
    s2 = 0
    y = 1
    for i in range (len(txt)):
        s1+=ord(txt[i])
        s2+=y*ord(txt[i])
        y += 1
        if y==17:
            y=1
    s1 = s1 %256
    s2 = s2 %256
    return hex(256*s1+s2)

print ("Code de contrôle : ", checksum(seq))


""" REPLICATION """

def rep(c):
    r = ''
    if c == 'A':
        r= 'T'
    elif c == 'T' :
        r= 'A'
    elif c == 'G':
        r = 'C'
    elif c == 'C' :
        r = 'G'
    return r

def replication(s) :
    repl = s
    L = len(s)
    for i in range(L):
        c = s[L-1-i]
        repl = repl + rep(c)
    return repl
    
def ARN(s):
    arn = s.replace('T', 'U')
    return arn

seq_rep = replication(seq)
seq_arn = ARN(seq_rep)

""" Recherche naïve codon start """

def recherche(motif, source):
    pos = []
    n = len(source)
    m = len(motif)
    for i in range(n-m):
        j = 0
        while j <  m and source[i+j]==motif[j]:
            j = j+1
        if (j == m):
            pos.append(i)
    return pos
  
codon_start = "AUG" 
starts = recherche(codon_start, seq_arn)
print ("AUG", starts)


""" Décodage ARN """
      
codon_end = ["UAA", "UAG", "UGA"]  

def decode(debut):
    codons=[]
    seq_code = seq_arn[debut:]
    L = len(seq_code)
    i = 0
    inseq = True
    while inseq and  i < L - 3 :
        codon = seq_code[i:i+3]
        if codon in codon_end :
            inseq = False
        else:
            codons.append(codon)
            i = i + 3
    return debut + i + 3, codons

fin0, proteine0 = decode(starts[0])
print("Première protéine : ", proteine0)

istart = 0 
fin = 0
sequences = []
while istart < len(starts):
    while starts[istart] < fin : 
        istart += 1
    fin, seq = decode(starts[istart])
    sequences.append(seq)
    istart += 1

for seq in sequences : 
    print ("Séquence : ", seq, "longueur :", len(seq) )



""" Base de données sqllite """

import sqlite3 
conn = sqlite3.connect('Genome.sqlite3')
cur = conn.cursor()

proteines = []
for seq in sequences :
    proteine = []
    for codon in seq : 
        param = (codon,)
        cur.execute('SELECT AcideAmine FROM GENOME WHERE Codon = ?', param)
        AA = cur.fetchone()
        proteine.append(str(AA[0]))
    proteines.append(proteine)
    print ("Protéine : ", len(proteine), " acides aminés : ", proteine)
cur.close()    
conn.close()	


""" Ecriture de fichier texte """

res = open('GenomeProteine.txt', 'w', encoding='utf8')
for i in range(len(proteines)):
    ch = "Protéine n°" + str(i+1) + " - " + str(len(proteines[i])) + " acides aminés : "
    res.write(ch)
    first = True
    for aa in proteines[i] : 
        if first :
            first = False
        else :
            res.write("-")
        res.write(aa)
    res.write("\r\n") ; 
res.close()

""" Classe Robot """

class Robot():
    def __init__(self):
        self.Resine = ""
        self.Ajout = ""
        self.AA = []
    
    def imprime(self):
        s = self.Resine
        if len(self.AA) == 0 and self.Resine != "":
            s = s + "Cl"
        else :
            for i in range(len(self.AA)):
                if i == 0 and self.Resine == "" :
                    s = "HOOC-"
                else : 
                    s = s + "CO-"
                s = s + "[" + self.AA[i] + "]-NH"
                if i == len(self.AA)-1:
                    s = s + "2"
                else:
                    s = s + "-"
        if self.Ajout != "":
            s = s + " + " + "HOOC-["+self.Ajout +"]-NH2"
        print(s)
    
    def preparer(self):
        self.Resine = "Polystère-CH2-"
        self.imprime()
    
    def prelever(self, aa):
        self.Ajout = aa
        self.imprime()
        
    def ajouter(self):
        self.AA.append(self.Ajout)
        self.Ajout = ""
        self.imprime()
    
    def decrocher(self):
        self.Resine = ""
        self.imprime()

      
r = Robot()
r.preparer()
for i in range(len(proteine0)):
    r.prelever(proteine[len(proteine0)-1-i])
    r.ajouter()
r.decrocher()


