# -*- coding: utf-8 -*-
"""
Created on Sat Nov  4 23:48:14 2017

@author: Alain
"""

import matplotlib.pyplot as plt
import matplotlib.image as img
from math import sqrt
import random as rd

""" quelques couleurs """

blanc=[1.0,1.0,1.0]
noir=[0.0,0.0,0.0]
gris=[0.5,0.5,0.5]
rouge=[1.0,0.0,0.0]
bleu=[0.0,0.0,1.0]

""" fonctions utilitaires """

def fond(nl,nc,color):
    F=[[color for c in range(nc)] for l in range(nl)]
    return F

def largeur(image):
    return len(image[0])
def hauteur(image):
    return len(image)
    
def insert(fond,image,pos_x,pos_y):
    Lf = largeur(fond)
    Hf = hauteur(fond)
    Li = largeur(image)
    Hi = hauteur(image)
    y = 0
    while y < Hi and y + pos_y < Hf :
        x = 0
        while x < Li and x + pos_x < Lf :
            fond[y+pos_y][x+pos_x]=image[y][x]
            x = x + 1
        y = y + 1
        
""" drapeau français """

F = fond(200,300,blanc)

for l in range(len(F)):
    for c in range(len(F[l])):
        if c < len(F[l])/3 : 
            F[l][c]=bleu
        elif c > 2*len(F[l])/3:
            F[l][c]=rouge

plt.imshow(F)
plt.show()

""" drapeau japonais """

J = fond(200,300, blanc)
R = 60
for l in range(len(J)):
    for c in range(len(J[l])):
        if sqrt((100-l)**2 + (150-c)**2) < R :
            J[l][c]=rouge

plt.imshow(J)
plt.show()

""" damier """

def damier(n,p,color1,color2):#n case de p pixels
    base = fond(n*p,n*p,color1)
    motif = fond(p,p,color2)
    for i in range(n):
        for j in range(n):
            if (i+j)%2 == 0 :
                insert(base,motif,i*p,j*p)
    return base           
                
echec=damier(8,50,rouge,bleu)
plt.imshow(echec)
plt.show()

""" cavalier """

cavalier=img.imread("cavalier.png","png")

def rgba2rgb(image):
    nl = len(image)
    nc = len(image[0])
    rgb = fond(nl,nc,blanc)
    for l in range(nl):
        for c in range(nc):
            pixel = image[l][c]
            rgb[l][c]= [pixel[0],pixel[1],pixel[2]]
    return rgb
    
cavalier2 = rgba2rgb(cavalier)
plt.imshow(cavalier2)
plt.show()

x = rd.randint(0,7)
y = rd.randint(0,7)

insert(echec, cavalier2, 50*x,50*y)
plt.imshow(echec)
plt.show()


